#include "shaders.h"

CShader::CShader()
{
	bLoaded = false;
}

UINT CShader::getShaderID()
{
	return uiShader;
}

bool CShader::loadShader(char *sFile, int a_iType)
{
	FILE *File = fopen(sFile, "rb");

	if(File == NULL)
	{
		return false;
	}

    fseek(File, 0, SEEK_END);
    long Size = ftell(File);
    fseek(File, 0, SEEK_SET);
    char *Source = new char[Size + 1];
    fread(Source, 1, Size, File);
    fclose(File);
    Source[Size] = 0;

	uiShader = glCreateShader(a_iType);

	glShaderSource(uiShader, 1, (const char**)&Source, NULL);
	delete [] Source;
	glCompileShader(uiShader);

	int iCompilationStatus;
	glGetShaderiv(uiShader, GL_COMPILE_STATUS, &iCompilationStatus);

	if(iCompilationStatus == GL_FALSE)
	{
		return false;
	}

	iType = a_iType;
	bLoaded = true;

	return 1;
}

bool CShader::isLoaded()
{
	return bLoaded;
}

void CShader::deleteShader()
{
	if(!isLoaded())return;
	bLoaded = false;
	glDeleteShader(uiShader);
}

CShaderProgram::CShaderProgram()
{
	bLinked = false;
}

void CShaderProgram::createProgram()
{
	uiProgram = glCreateProgram();
}

bool CShaderProgram::addShaderToProgram(CShader* shShader)
{
	if(!shShader->isLoaded())return false;

	glAttachShader(uiProgram, shShader->getShaderID());

	return true;
}

bool CShaderProgram::linkProgram()
{
	glLinkProgram(uiProgram);
	int iLinkStatus;
	glGetProgramiv(uiProgram, GL_LINK_STATUS, &iLinkStatus);
	bLinked = iLinkStatus == GL_TRUE;
	return bLinked;
}

void CShaderProgram::deleteProgram()
{
	if(!bLinked)return;
	bLinked = false;
	glDeleteProgram(uiProgram);
}

void CShaderProgram::useProgram()
{
	if(bLinked)glUseProgram(uiProgram);
}
